package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualShopTFC;
import com.liquidnet.service.sweet.mapper.SweetManualShopTFCMapper;
import com.liquidnet.service.sweet.service.ISweetManualShopTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualShopTFCServiceImpl extends ServiceImpl<SweetManualShopTFCMapper, SweetManualShopTFC> implements ISweetManualShopTFCService {

    @Autowired
    private SweetManualShopTFCMapper sweetManualShopTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<List<SweetManualShopTFC>> getList(String manualId, Integer type) {
        try {
            List<SweetManualShopTFC> data = sweetManualShopTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualShopTFC.class).eq(SweetManualShopTFC::getManualId, manualId).eq(SweetManualShopTFC::getType, type).eq(SweetManualShopTFC::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualShopTFC> details(String manualShopId) {
        try {
            SweetManualShopTFC data = sweetManualShopTFCMapper.selectOne(Wrappers.lambdaQuery(SweetManualShopTFC.class).eq(SweetManualShopTFC::getManualShopId, manualShopId).eq(SweetManualShopTFC::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopTFC sweetManualShop = SweetManualShopTFC.getNew();
            sweetManualShop.setManualShopId(IDGenerator.nextSnowId());
            sweetManualShop.setManualId(manualId);
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShop.setStatus(1);
            sweetManualShopTFCMapper.insert(sweetManualShop);
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualShopId,String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopTFC sweetManualShop = SweetManualShopTFC.getNew();
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShopTFCMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopTFC.class).eq(SweetManualShopTFC::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualShopId,String manualId) {
        try {
            SweetManualShopTFC sweetManualShop = SweetManualShopTFC.getNew();
            sweetManualShop.setStatus(0);
            sweetManualShopTFCMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopTFC.class).eq(SweetManualShopTFC::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
