package com.liquidnet.service.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.*;
import com.liquidnet.service.sweet.mapper.SweetArtistsUrlMapper;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetManualMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
@Slf4j
public class RedisArDataUtils {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private SweetArtistsUrlMapper sweetArtistsUrlMapper;
    @Autowired
    private SweetManualMapper sweetManualMapper;

    public List<SweetPerformArtistTimeListDto> getArtistTimeList(String performanceId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MANUAL_ARTIST_TIME_LIST.concat(performanceId);
        redisUtil.del(redisKey);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            List<SweetPerformArtistTimeListDto> performArtistTimeList = new ArrayList<>();
            // 演出日期
            List<SweetManualAppletArDto> performTime = sweetManualMapper.getManualAppletArDto(performanceId);
            if (!CollectionUtil.isEmpty(performTime)) {
                Date dateEnd = DateUtil.parse(performTime.get(0).getTimeEnd(), DateUtil.DATE_SMALL_STR);
                Date dateStart = DateUtil.parse(performTime.get(0).getTimeStart(), DateUtil.DATE_SMALL_STR);
                int intervalDay = (int) DateUtil.intervalDays(dateStart, dateEnd);
                for (int i = 0; i <= intervalDay; i++) {
                    String time = DateUtil.format(DateUtil.addDay(dateStart, i), DateUtil.Formatter.yyyy_MM_dd);
                    SweetPerformArtistTimeListDto performArtistTimeListDto = SweetPerformArtistTimeListDto.getNew();
                    performArtistTimeListDto.setStartTime(time);
                    // 场地
                    List<SweetManualArtistStageListArDto> stageList = sweetManualArtistsMapper.getStageNameListAr(performanceId);
                    // 艺人
                    List<SweetManualArtistListArDto> artistList = sweetManualArtistsMapper.getManualListAr(performanceId);
                    for (SweetManualArtistListArDto artist : artistList) {
                        String performanceStart = artist.getPerformanceStart();
                        String performanceEnd = artist.getPerformanceEnd();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Long timestampStart = 0L;
                        Long timestampEnd = 0L;
                        try {
                            Date start = format.parse(performanceStart);
                            Date end = format.parse(performanceEnd);
                            timestampStart = start.getTime();
                            timestampEnd = end.getTime();
                        } catch (Exception e) {

                        }
                        artist.setPerformanceStartDate(timestampStart);
                        artist.setPerformanceEndDate(timestampEnd);
                        List<SweetManualArtistResourceUrlArDto> urlList = sweetArtistsUrlMapper.selectListOfAid(artist.getArtistsId());
                        artist.setResourceUrl(urlList);
                    }
                    for (SweetManualArtistStageListArDto stage : stageList) {
                        List<SweetManualArtistListArDto> artistListArList = new ArrayList<>();
                        for (SweetManualArtistListArDto artist : artistList) {
                            if (artist.getPerformanceStart().contains(time) && stage.getStageId().equals(artist.getStageId())) {
                                artistListArList.add(artist);
                            }
                        }
                        stage.setArtistList(artistListArList);
                    }
                    performArtistTimeListDto.setStageList(stageList);

                    performArtistTimeList.add(performArtistTimeListDto);
                }
                redisUtil.set(redisKey, performArtistTimeList);
            }

            return performArtistTimeList;
        } else {
            return (List<SweetPerformArtistTimeListDto>) obj;
        }
    }
}
