package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 票
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinTicketStatus implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * ticket_status_id
     */
    private String ticketStatusId;

    /**
     * 票关联id
     */
    private String ticketId;

    /**
     * 是否学生票 0否 1是
     */
    private Integer isStudent;

    /**
     * 是否电子票 0否 1是
     */
    private Integer isElectronic;

    /**
     * 是否快递票 0否 1是
     */
    private Integer isExpress;

    /**
     * 票状态 -1删除;0未提交;1审核中;2审核中（自动在售）;3审核通过;4审核未通过;6在售;7停售;8售罄;9未开始;10已结束
     */
    private Integer status;

    /**
     * 可验证次数
     */
    private Integer counts;

    /**
     * 兑换状态 6可兑换 7不可兑换
     */
    private Integer statusExchange;

    /**
     * 是否显示二维码 0否 1是
     */
    private Integer isShowCode;

    /**
     * 二维码显示时间
     */
    private LocalDateTime qrCodeShowTime;

    /**
     * 是否开启缺票登记 0否 1是
     */
    private Integer isLackRegister;

    /**
     * 总库存
     */
    private Integer totalGeneral;

    /**
     * 总兑换库存
     */
    private Integer totalExchange;

    /**
     * 剩余库存
     */
    private Integer surplusGeneral;

    /**
     * 剩余兑换库存
     */
    private Integer surplusExchange;

    /**
     * 1寄付 2到付
     */
    private Integer expressType;

    /**
     * 是否开启转赠 0关闭 1开启
     */
    private Integer isTransfer;

    /**
     * 是否开启转赠 0关闭 1开启
     */
    private Integer isTrueName;

    /**
     * 限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer limitCount;

    /**
     * 会员限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)
     */
    private Integer memberLimitCount;

    /**
     * 是否会员专属 0不是 1是
     */
    private Integer isExclusive;

    /**
     * 是否关联会员 0不是 1是
     */
    private Integer isMember;

    /**
     * 是否关联代理 0不是 1是
     */
    private Integer isAgent;

    /**
     * 是否同步大麦 0不关联 1关联
     */
    private Integer syncDamai;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinTicketStatus obj = new KylinTicketStatus();
    public static KylinTicketStatus getNew() {
        try {
            return (KylinTicketStatus) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinTicketStatus();
        }
    }

    public Object[] insert(KylinTicketStatus vo) {
        return new Object[]{
                vo.getTicketStatusId(),vo.getTicketId(),vo.getIsStudent(),
                vo.getIsElectronic(),vo.getIsExpress(),vo.getStatus(),
                vo.getCounts(),vo.getStatusExchange(),vo.getIsShowCode(),
                vo.getQrCodeShowTime(),vo.getIsLackRegister(),vo.getTotalGeneral(),
                vo.getTotalExchange(),vo.getSurplusGeneral(),vo.getSurplusExchange(),
                vo.getExpressType(),vo.getIsTransfer(),vo.getIsTrueName(),vo.getLimitCount(),
                vo.getMemberLimitCount(),vo.getIsExclusive(),vo.getIsMember(),
                0,0,vo.getCreatedAt(),vo.getUpdatedAt()

        };
    }
}
