package com.liquidnet.service.sweet.dto;

import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;

import java.time.LocalDateTime;

@Data
public class SweetIntegralActivityDto {

    /**
     * 活动id
     */
    private String integralActivityId;

    /**
     * 活动名称
     */
    private String activityTitle;

    /**
     * 活动图片
     */
    private String activityImg;

    /**
     * 活动类型 1转盘
     */
    private Integer activityType;

    /**
     * 活动玩一次所需积分
     */
    private Integer activityNum;

    /**
     * 活动时间类型 1长期 2开始结束时间
     */
    private Integer timeType;

    /**
     * 如果活动有时间限制 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 如果活动有时间限制 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 快递费用类型 1包邮 2到付
     */
    private Integer expressFeeType;

    /**
     * 活动规则
     */
    private String activityRules;

    /**
     * 是否上线 1未上线 2已上线
     */
    private Integer isOnline;

    /**
     * 创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private Integer prizeNum;
    private Integer drawNum;
}
