package com.liquidnet.service.goblin.dto.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description: NFT兑换码表
 * @Date:Create：in 2022/4/19 1:55 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
@HeadRowHeight(value = 20)//设置表头行高
@ColumnWidth(value = 15)//设置表头行宽
public class GoblinNftExCodeVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 兑换码id
     */
    @ApiModelProperty(position = 10,required = true,value ="兑换码id")
    private String codeId;

    /**
     * 活动id
     */
    @ApiModelProperty(position = 11,required = true,value ="活动id")
    private String activityId;


    /**
     * 兑换码
     */

    @ApiModelProperty(position = 12,required = true,value ="兑换码")
    private String code;

    /**
     * 商品id
     */
    @ApiModelProperty(position = 13,required = true,value ="商品id")
    private String spuId;

    /**
     * 款式id
     */
    @ApiModelProperty(position = 14,required = true,value ="产品id")
    private String skuId;

    /**
     * 盲盒抽取的款式id
     */
    @ApiModelProperty(position = 15,required = true,value ="盲盒抽取的款式id")
    private String boxSkuId;

    /**
     * 店铺id
     */
    @ApiModelProperty(position = 16,required = true,value ="店铺id")
    private String storeId;


    /**
     * 兑换码状态 1 未兑换  2  已兑换
     */

    @ApiModelProperty(position = 17,required = true,value ="兑换码状态 1 未兑换  2  已兑换")
    private Integer state;


    /**
     * 兑换用户id
     */

    @ApiModelProperty(position = 18,required = true,value ="兑换用户id")
    private String redeemUid;

    /**
     * 操作用户id
     */
    @ApiModelProperty(position = 19,required = true,value ="操作用户id")
    private String adminUid;


    /**
     * 兑换时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 20,required = true,value ="兑换时间")
    private LocalDateTime redeemAt;


    /**
     * 创建时间
     */
    @ApiModelProperty(position = 21,required = true,value ="创建时间")
    private LocalDateTime createdAt;


    /**
     * 更新时间
     */
    @ApiModelProperty(position = 22,required = true,value ="更新时间")
    private LocalDateTime updatedAt;

    /**
     * 兑换限购
     */
    @ApiModelProperty(position = 23,required = true,value ="兑换限购")
    private Integer exLimit;


    /**
     * 兑换生效开始时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 24,required = true,value ="兑换生效开始时间")
    private LocalDateTime exStartTime;


    /**
     * 兑换生效结束时间
     */

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 25,required = true,value ="兑换生效结束时间")
    private LocalDateTime exStopTime;

    /**
     * sku名称
     */
    @ApiModelProperty(position = 26,required = true,value ="sku名称")
    private String skuName;
    /**
     * 兑换结果sku名称
     */
    @ApiModelProperty(position = 27,required = true,value = "兑换结果sku名称")
    private String resultSkuName;


    /**
     * 是否盲和
     */
    private String unBox;



    private static final GoblinNftExCodeVo obj = new GoblinNftExCodeVo();

    public static GoblinNftExCodeVo getNew() {
        try {
            return (GoblinNftExCodeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftExCodeVo();
        }
    }

    public GoblinNftExCodeVo copy(GoblinNftExCode goblinNftExCode){
        if (null == goblinNftExCode)return this;
        this.setCodeId(goblinNftExCode.getCodeId());
        this.setActivityId(goblinNftExCode.getActivityId());
        this.setCode(goblinNftExCode.getCode());
        this.setSkuId(goblinNftExCode.getSkuId());
        this.setState(goblinNftExCode.getState());
        this.setBoxSkuId(goblinNftExCode.getBoxSkuId());
        this.setRedeemUid(goblinNftExCode.getRedeemUid());
        this.setAdminUid(goblinNftExCode.getAdminUid());
        this.setRedeemAt(goblinNftExCode.getRedeemAt());
        this.setCreatedAt(goblinNftExCode.getCreatedAt());
        this.setUpdatedAt(goblinNftExCode.getUpdatedAt());
        return this;
    }


}
