package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.sweet.task.FeignSweetTaskActivityClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * sweet
 */
@Component
public class SweetCityVoteTaskHandler {
    @Autowired
    private FeignSweetTaskActivityClient feignSweetTaskActivityClient;

    @XxlJob(value = "sev-sweet:cityVoteStat")
    public void cityVoteStatHandler() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            String[] paramArray = jobParam.split(",");

            for (String type : paramArray) {
                Boolean data = feignSweetTaskActivityClient.setStatList(Integer.parseInt(type)).getData();
                XxlJobHelper.log("type:{},结果:{}", data);
            }
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

}
