package com.liquidnet.service.sweet.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisBetterConfigImpl;
import cn.binarywang.wx.miniapp.message.WxMaMessageRouter;
import com.liquidnet.service.sweet.handler.ApplySubscribeHandler;
import com.liquidnet.service.sweet.handler.ApplyUnsubscribeHandler;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.PostConstruct;

@Configuration
@Slf4j
public class WechatMaConfigure {

    private static String appletAppidStrawberry;
    private static String appletSecretStrawberry;

    private static String appletAppidFive;
    private static String appletSecretFive;

    private static String appletAppidMdsk;
    private static String appletSecretMdsk;

    private static String appletAppidZhengzai;
    private static String appletSecretZhengzai;

    private static String appletAppidAirship;
    private static String appletSecretAirship;

    private static String appletAppidSmile;
    private static String appletSecretSmile;

    @Value("${liquidnet.wechat.applet.strawberry.appid}")
    public void setAppletAppidStrawberry(String appletAppidStrawberry) {
        WechatMaConfigure.appletAppidStrawberry = appletAppidStrawberry;
    }
    @Value("${liquidnet.wechat.applet.strawberry.secret}")
    public void setAppletSecretStrawberry(String appletSecretStrawberry) {
        WechatMaConfigure.appletSecretStrawberry = appletSecretStrawberry;
    }

    @Value("${liquidnet.wechat.applet.five.appid}")
    public void setAppletAppidFive(String appletAppidFive) {
        WechatMaConfigure.appletAppidFive = appletAppidFive;
    }
    @Value("${liquidnet.wechat.applet.five.secret}")
    public void setAppletSecretFive(String appletSecretFive) {
        WechatMaConfigure.appletSecretFive = appletSecretFive;
    }

    @Value("${liquidnet.wechat.applet.mdsk.appid}")
    public void setAppletAppidMdsk(String appletAppidMdsk) {
        WechatMaConfigure.appletAppidMdsk = appletAppidMdsk;
    }
    @Value("${liquidnet.wechat.applet.mdsk.secret}")
    public void setAppletSecretMdsk(String appletSecretMdsk) {
        WechatMaConfigure.appletSecretMdsk = appletSecretMdsk;
    }

    @Value("${liquidnet.wechat.applet.zhengzai.appid}")
    public void setAppletAppidZhengzai(String appletAppidZhengzai) {
        WechatMaConfigure.appletAppidZhengzai = appletAppidZhengzai;
    }
    @Value("${liquidnet.wechat.applet.zhengzai.secret}")
    public void setAppletSecretZhengzai(String appletSecretZhengzai) {
        WechatMaConfigure.appletSecretZhengzai = appletSecretZhengzai;
    }

    @Value("${liquidnet.wechat.applet.airship.appid}")
    public void setAppletAppidAirship(String appletAppidAirship) {
        WechatMaConfigure.appletAppidAirship = appletAppidAirship;
    }
    @Value("${liquidnet.wechat.applet.airship.secret}")
    public void setAppletSecretAirship(String appletSecretAirship) {
        WechatMaConfigure.appletSecretAirship = appletSecretAirship;
    }

    @Value("${liquidnet.wechat.applet.smile.appid}")
    public void setAppletAppidSmile(String appletAppidSmile) {
        WechatMaConfigure.appletAppidSmile = appletAppidSmile;
    }
    @Value("${liquidnet.wechat.applet.smile.secret}")
    public void setAppletSecretSmile(String appletSecretSmile) {
        WechatMaConfigure.appletSecretSmile = appletSecretSmile;
    }

    private WxMaService wxMaAppletStrawberryService;
    private WxMaService wxMaAppletFiveService;
    private WxMaService wxMaAppletMdskService;
    private WxMaService wxMaAppletZhengzaiService;
    private WxMaService wxMaAppletAirshipService;
    private WxMaService wxMaAppletSmileService;

    private WxMaMessageRouter wxMaStrawberryMessageRouter;
    private WxMaMessageRouter wxMaFiveMessageRouter;
    private WxMaMessageRouter wxMaMdskMessageRouter;
    private WxMaMessageRouter wxMaZhengzaiMessageRouter;
    private WxMaMessageRouter wxMaAirshipMessageRouter;
    private WxMaMessageRouter wxMaSmileMessageRouter;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private ApplySubscribeHandler subscribeHandler;
    @Autowired
    private ApplyUnsubscribeHandler unsubscribeHandler;

    @PostConstruct
    public void init() {
        wxMaAppletStrawberryService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:strawberry");
                wxMaDefaultConfig.setAppid(appletAppidStrawberry);
                wxMaDefaultConfig.setSecret(appletSecretStrawberry);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletFiveService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:five");
                wxMaDefaultConfig.setAppid(appletAppidFive);
                wxMaDefaultConfig.setSecret(appletSecretFive);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletMdskService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:mdsk");
                wxMaDefaultConfig.setAppid(appletAppidMdsk);
                wxMaDefaultConfig.setSecret(appletSecretMdsk);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletZhengzaiService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:zhengzai");
                // WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMaDefaultConfig.setAppid(appletAppidZhengzai);
                wxMaDefaultConfig.setSecret(appletSecretZhengzai);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletAirshipService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:airship");
                wxMaDefaultConfig.setAppid(appletAppidAirship);
                wxMaDefaultConfig.setSecret(appletSecretAirship);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletSmileService = new WxMaServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMaRedisBetterConfigImpl wxMaDefaultConfig = new WxMaRedisBetterConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:applet:smile");
                wxMaDefaultConfig.setAppid(appletAppidSmile);
                wxMaDefaultConfig.setSecret(appletSecretSmile);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaStrawberryMessageRouter = new WxMaMessageRouter(wxMaAppletStrawberryService);
        wxMaFiveMessageRouter = new WxMaMessageRouter(wxMaAppletFiveService);
        wxMaMdskMessageRouter = new WxMaMessageRouter(wxMaAppletMdskService);
        wxMaZhengzaiMessageRouter = new WxMaMessageRouter(wxMaAppletZhengzaiService);
        wxMaAirshipMessageRouter = new WxMaMessageRouter(wxMaAppletAirshipService);
        wxMaSmileMessageRouter = new WxMaMessageRouter(wxMaAppletSmileService);
    }

    public WxMaService getWxMaService(Integer anum) {
        switch (anum) {
            case 1:
                return wxMaAppletStrawberryService;
            case 2:
                return wxMaAppletFiveService;
            case 3:
                return wxMaAppletMdskService;
            case 4:
                return wxMaAppletZhengzaiService;
            case 5:
                return wxMaAppletAirshipService;
            case 6:
                return wxMaAppletSmileService;
        }
        return null;
    }

    public String getWxMaAppid(Integer anum) {
        switch (anum) {
            case 1:
                return appletAppidStrawberry;
            case 2:
                return appletAppidFive;
            case 3:
                return appletAppidMdsk;
            case 4:
                return appletAppidZhengzai;
            case 5:
                return appletAppidAirship;
            case 6:
                return appletAppidSmile;
        }
        return "";
    }

    public WxMaMessageRouter getWxMaMessageRouter(Integer pnum) {
        switch (pnum) {
            case 1:
                return wxMaStrawberryMessageRouter;
            case 2:
                return wxMaFiveMessageRouter;
            case 3:
                return wxMaMdskMessageRouter;
            case 4:
                return wxMaZhengzaiMessageRouter;
            case 5:
                return wxMaAirshipMessageRouter;
            case 6:
                return wxMaSmileMessageRouter;
        }
        return null;
    }

    public WxMaMessageRouter messageRouter(Integer type) {
        WxMaMessageRouter router = getWxMaMessageRouter(type);
        // 消息去重
//        router.setMessageDuplicateChecker(wxMessageInMemoryDuplicateChecker);

        // 订阅事件
        router.rule().async(false).msgType(WxConsts.XmlMsgType.EVENT)
                .event("subscribe_msg_popup_event")
                .handler(subscribeHandler)
                .end();
        /*router.rule().async(false)
                .content("订阅消息")
                .handler(subscribeHandler)
                .end();*/

        // 取消订阅事件
        router.rule().async(false).msgType(WxConsts.XmlMsgType.EVENT)
                .event("subscribe_msg_popup_event")
                .handler(unsubscribeHandler)
                .end();

        return router;
    }
}
