package com.liquidnet.service.merchant.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "MerchantAuthorizationPerformanceVo", description = "演出纬度权限聚合")
@Data
public class MerchantAuthorizationPerformanceVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -225012446820470899L;

    @ApiModelProperty(value = "演出ID")
    private String performanceId;

    @ApiModelProperty(value = "权利人")
    private String uid;

    @ApiModelProperty(value = "权利人演出所有角色")
    private List<String> uidRoles;

    @ApiModelProperty(value = "权利人演出所有权限")
    private List<String> permissionIds;

    private static final MerchantAuthorizationPerformanceVo obj = new MerchantAuthorizationPerformanceVo();

    public static MerchantAuthorizationPerformanceVo getNew() {
        try {
            return (MerchantAuthorizationPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantAuthorizationPerformanceVo();
    }
}
