use dev_ln_scene;

-- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS goblin_nft_ex_code;
CREATE TABLE goblin_nft_ex_code
(
    mid        BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    code_id    VARCHAR(64) NOT NULL DEFAULT '' COMMENT '兑换码id',
    code       VARCHAR(64) NOT NULL DEFAULT '' COMMENT '兑换码',
    sku_id     VARCHAR(64) NOT NULL DEFAULT '' COMMENT '款式id',
    state      TINYINT UNSIGNED     DEFAULT 1 comment '兑换码状态 1未兑换 2已兑换 3已失效',
    redeem_uid VARCHAR(64) NOT NULL DEFAULT '' COMMENT '兑换用户id',
    redeem_at  DATETIME    NULL     DEFAULT NULL COMMENT '兑换时间',
    admin_uid  VARCHAR(64) NOT NULL DEFAULT '' COMMENT '操作用户id',
    created_at DATETIME    NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at DATETIME    NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `idx_nft_code_id` (`code_id`),
    KEY `idx_nft_code` (`code`),
    KEY `idx_nft_sku_id` (`sku_id`),
    KEY `idx_nft_redeem_uid` (`redeem_uid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT兑换码表';

-- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS goblin_nft_ex_activity;
CREATE TABLE goblin_nft_ex_activity
(
    mid         BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    activity_id VARCHAR(64) NOT NULL DEFAULT '' COMMENT '活动id',
    title       VARCHAR(64) NOT NULL DEFAULT '' COMMENT '活动标题',
    created_at  DATETIME    NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at  DATETIME    NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `idx_nft_activity_id` (`activity_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT兑换活动表';

/*DROP TABLE IF EXISTS goblin_nft_ex_spu;
CREATE TABLE goblin_nft_ex_spu
(
    mid           BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    activity_id   VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '活动id',
    spu_id        VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '商品id',
    created_at    DATETIME         NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at    DATETIME         NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `nft_activity_id_index` (`activity_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT兑换活动关联SPU表';*/

DROP TABLE IF EXISTS goblin_nft_ex_sku;
CREATE TABLE goblin_nft_ex_sku
(
    mid           BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    activity_id   VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '活动id',
    spu_id        VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '商品id',
    sku_id        VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '款式id',
    ex_stock      INT UNSIGNED     NOT NULL DEFAULT 0 COMMENT '兑换库存',
    ex_limit      INT UNSIGNED     NOT NULL DEFAULT 0 COMMENT '兑换限购',
    ex_start_time DATETIME         NULL     DEFAULT NULL COMMENT '兑换生效开始时间',
    ex_stop_time  DATETIME         NULL     DEFAULT NULL COMMENT '兑换生效结束时间',
    created_at    DATETIME         NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at    DATETIME         NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `idx_nft_ex_activity_id` (`activity_id`),
    KEY `idx_nft_ex_spu_id` (`spu_id`),
    KEY `idx_nft_ex_sku_id` (`sku_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT兑换活动关联SKU表';