package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import com.liquidnet.service.goblin.service.IGoblinStoreZhengzaiService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "正在下单相关-商铺")
@RestController
@RequestMapping("/zhengzai/store")
public class GoblinStoreZhengzaiController {

    @Autowired
    IGoblinStoreZhengzaiService goblinStoreZhengzaiService;
//    @Autowired
//    IGoblinOrderService goblinOrderService;
    @Autowired
    IGoblinOrderAppService goblinOrderAppService;

    @GetMapping("market/list")
    @ApiOperation("正在下单-活动列表")
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        return goblinStoreZhengzaiService.getZhengzaiMarketList();
    }

    @GetMapping("spu/list")
    @ApiOperation("正在下单-参与活动的spu")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiGoodVo>> getStoreList(@RequestParam("marketId") @Valid String marketId) {
        return goblinStoreZhengzaiService.getSpuList(marketId);
    }

    @PostMapping("list")
    @ApiOperation("订单列表[商铺]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1"),
    })
    public ResponseDto<List<GoblinAppOrderListVo>> orderList(@RequestParam("page") @Valid int page) {
        return goblinStoreZhengzaiService.orderList(page);
    }

    @PostMapping("orderPush")
    @ApiOperation("正在下单-出货")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderMasterCode", value = "主订单号"),
    })
    public ResponseDto<Boolean> orderPush(@RequestParam("orderMasterCode") @Valid String orderMasterCode) {
        return goblinStoreZhengzaiService.orderPush(orderMasterCode);
    }

    @PostMapping("listByCode")
    @ApiOperation("列表[根据masterCode]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderMasterCode", value = "主订单号"),
    })
    public ResponseDto<List<GoblinAppOrderListVo>> orderListByMaster(@RequestParam("orderMasterCode") @Valid String orderMasterCode) {
        return goblinOrderAppService.orderListByMaster(orderMasterCode);
    }

    @PostMapping("details")
    @ApiOperation("订单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<GoblinAppOrderDetailsVo> orderDetails(@RequestParam("orderId") @Valid String orderId) {
        return goblinOrderAppService.orderDetails(orderId, null);
    }

//    @PostMapping("paySuccess")
//    @ApiOperation("汇付支付成功回调")
//    @ResponseBody
//    public String refundDetails(HttpServletRequest request) {
//        return goblinOrderAppService.huiFuSync(request);
//    }
}
