package com.liquidnet.service.adam.constant;

public class AdamBeneficiaryConstants {

    public enum StatusEnum implements AdamBaseEnum {
        NORMAL("normal", "normal"),
        DELETE("delete", "delete"),
        ;

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

    /**
     * 实体类型
     */
    public enum LegalEntityTypeEnum implements AdamBaseEnum {
        INDIVIDUAL("individual", "Individual"),
        COMPANY("company", "Company"),
        ;

        public static LegalEntityTypeEnum getEnumByCode(String code) {
            LegalEntityTypeEnum[] array = values();
            for (LegalEntityTypeEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        LegalEntityTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

    public enum PaymentMethodPriorityChargeTypeEnum implements AdamBaseEnum {
        ours("ours", "ours"),
        shared("shared", "shared"),
        ;

        private String code;

        private String desc;

        PaymentMethodPriorityChargeTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

}
