package com.liquidnet.service.adam.constant;

/**
 * 公司常量
 *
 * @author LiChen
 * @date 2020-09-16 16:16
 */
public class AdamComConstants {

    public enum ComStateEnum implements AdamBaseEnum {
        S1("1", "Company Infomation"),
        S2("2", "Business Use"),
        S3("3", "Primary Authorized Person Details"),
        S4("4", "Shareholders Infomation"),
        S5("5", "Financial Compliance"),
        S6("6", "Review"),
        S7("7", "Audit not activated"),
        S8("8", "Activated");

        private String code;

        private String desc;

        ComStateEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

    /**
     * 公司类型枚举
     */
    public enum ComTypeEnum implements AdamBaseEnum {
        E_COMMERCE_PLATFORM("E_COMMERCE_PLATFORM", "E-Commerce (Platform)"),
        E_COMMERCE_MERCHANT("E_COMMERCE_MERCHANT", "E-Commerce (Merchant)"),
        MONEY_TRANSFER_OPERATOR("MONEY_TRANSFER_OPERATOR", "Money Transfer Operator"),
        CORPORATE("CORPORATE", "Corporate"),
        OTHER("OTHER", "Other");

        private String code;

        private String desc;

        ComTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 公司实体结构枚举
     */
    public enum ComEntityStructureEnum implements AdamBaseEnum {
        PRIVATE("PRIVATE", "Private"),
        PUBLIC_LISTED("PUBLIC_LISTED", "Public Listed"),
        TRUST("TRUST", "Trust"),
        GOVERNMENT("GOVERNMENT", "Government"),
        ASSOCIATION("ASSOCIATION", "Association"),
        CHARITY_OR_NON_PROFIT("CHARITY_OR_NON_PROFIT", "Charity or Non-profit"),
        PARTNERSHIP("PARTNERSHIP", "Partnership"),
        SOLE_PROPRIETOR("SOLE_PROPRIETOR", "Sole Proprietor");

        private String code;

        private String desc;

        ComEntityStructureEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 公司行业类别枚举
     */
    public enum ComIndustryCategoryEnum implements AdamBaseEnum {

        IC1("IC1", "Agriculture; plantations;other rural sectors"),
        IC2("IC2", "Basic Metal Production"),
        IC3("IC3", "Chemical industries"),
        IC4("IC4", "Commerce"),
        IC5("IC5", "Construction"),
        IC6("IC6", "Education"),
        IC7("IC7", "Financial services; professional services"),
        IC8("IC8", "Food; drink; tobacco"),
        IC9("IC9", "Forestry; wood; pulp and paper"),
        IC10("IC10", "Health services"),
        IC11("IC11", "Hotels; tourism; catering"),
        IC12("IC12", "Mechanical and electrical engineering"),
        IC13("IC13", "Media; culture; graphical"),
        IC14("IC14", "Mining (coal; other mining)"),
        IC15("IC15", "Oil and gas production; oil refining"),
        IC16("IC16", "Postal and telecommunications services"),
        IC17("IC17", "Public service"),
        IC18("IC18", "Shipping; ports; fisheries; inland waterways"),
        IC19("IC19", "Textiles; clothing; leather; footwear"),
        IC20("IC20", "Transport (including civil aviation; railways; road transport)"),
        IC21("IC21", "Transport equipment manufacturing"),
        IC22("IC22", "Utilities (water; gas; electricity)"),

        OTHER("OTHER", "Other"),
        ;

        private String code;

        private String desc;

        ComIndustryCategoryEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 公司每月逾期交易量
     */
    public enum ComExpectedTransactionEnum implements AdamBaseEnum {
        E_100000("100000", "$0 to $100,000 USD"),
        E_500000("500000", "$100,000 to $500,000 USD"),
        E_1000000("1000000", "$500,000 to $1M USD"),
        E_10000000("10000000", "$1M to $10M USD"),
        E_100000000("100000000", "$10M to $100M USD"),
        E_1000000000("1000000000", "Above $100M USD");

        private String code;

        private String desc;

        ComExpectedTransactionEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 公司使用Liquidnet用途
     */
    public enum ComLiquidnetUseEnum implements AdamBaseEnum {
        Collection("Collection", "Collection"),
        Disbursement("Disbursement", "Disbursement"),
        FX("FX", "FX");

        private String code;

        private String desc;

        ComLiquidnetUseEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    /**
     * 身份证类型枚举
     * ID TYPE ENUM
     */
    public enum IdTypeEnum implements AdamBaseEnum {
        NATIONAL_IDENTITY_CARD(" NATIONAL_IDENTITY_CARD", " National Identity Card"),
        DRIVER_LICENSE("DRIVER_LICENSE", "Driver License"),
        Passport("PASSPORT", "Passport");

        private String code;

        private String desc;

        IdTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
