package com.liquidnet.service.adam.constant;

import com.liquidnet.service.bank.currencycloud.constant.BankCcConversionConstants;
import com.liquidnet.service.bank.currencycloud.constant.BankCcFundingConstants;
import org.springframework.util.StringUtils;

public class AdamConversionConstants {

    public enum StatusEnum implements AdamBaseEnum {
        READY_TO_SETTLE("ready_to_settle", "Ready to Settle"),
        FAILED("failed", "Failed"),
        COMPLETED("completed", "Completed"),
        ;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        public static String getByBankStatus(String bankChannel, String bankConversionStatus) {
            String ret = null;
            if (StringUtils.isEmpty(bankChannel)) {
                bankChannel = AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode();
            }
            if (AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode().equals(bankChannel)) {
                BankCcConversionConstants.StatusEnum enumByCode = BankCcConversionConstants.StatusEnum.getEnumByCode(bankConversionStatus);
                if (enumByCode == null) {
                    return ret;
                }

                switch (enumByCode) {
                    case AWAITING_FUNDS:
                        ret = READY_TO_SETTLE.getCode();
                        break;
                    case FUNDS_SENT:
                        ret = READY_TO_SETTLE.getCode();
                        break;
                    case FUNDS_ARRIVED:
                        ret = READY_TO_SETTLE.getCode();
                        break;
                    case TRADE_SETTLED:
                        ret = COMPLETED.getCode();
                        break;
                    case CLOSED:
                        ret = FAILED.getCode();
                        break;
                    default:
                        return ret;
                }
            }

            return ret;

        }

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum FixedSideEnum implements AdamBaseEnum {
        BUY("buy", "Buy"),
        SELL("sell", "Sell"),
        ;

        public static FixedSideEnum getEnumByCode(String code) {
            FixedSideEnum[] array = values();
            for (FixedSideEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        FixedSideEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
