package com.liquidnet.service.adam.constant;

import com.liquidnet.service.account.common.FinConstants;

public class AdamDashboardConstants {

    public enum PeriodEnum implements AdamBaseEnum {
        TODAY("today", "Last 24 Hours"),
        WEEKLY("weekly", "Last 7 Days"),
        MONTHLY("monthly", "Last 30 Days"),
        ;

        public static FinConstants.Dashboard.Period getFinPerid(String period) {
            PeriodEnum enumByCode = PeriodEnum.getEnumByCode(period);
            if (enumByCode == null) {
                return FinConstants.Dashboard.Period.L24H;
            }

            switch (enumByCode) {
                case TODAY:
                    return FinConstants.Dashboard.Period.L24H;
                case WEEKLY:
                    return FinConstants.Dashboard.Period.L7D;
                case MONTHLY:
                    return FinConstants.Dashboard.Period.L30D;
                default:
                    return FinConstants.Dashboard.Period.L24H;
            }
        }

        public static PeriodEnum getEnumByCode(String code) {
            PeriodEnum[] array = values();
            for (PeriodEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        PeriodEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum BalanceTypeEnum implements AdamBaseEnum {
        AVAILABLE("Available", "Available Balance"),
        PENDING("Pending", "Pending Balance"),
        ;

        private String code;

        private String desc;

        BalanceTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
