package com.liquidnet.service.adam.constant;

import com.liquidnet.service.bank.currencycloud.constant.BankCcFundingConstants;
import org.springframework.util.StringUtils;

/**
 * 充值常量
 *
 * @author LiChen
 * @date 2020-09-16 16:16
 */
public class AdamFundingConstants {

    public enum StatusEnum implements AdamBaseEnum {
        PROCESSING("processing", "Processing"),
        FAILED("failed", "Failed"),
        COMPLETED("completed", "Completed"),
        ;

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static String getByBankStatus(String bankChannel, String bankFundingStatus) {
            String ret = null;
            if (StringUtils.isEmpty(bankChannel)) {
                bankChannel = AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode();
            }
            if (AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode().equals(bankChannel)) {
                BankCcFundingConstants.StatusEnum enumByCode = BankCcFundingConstants.StatusEnum.getEnumByCode(bankFundingStatus);
                if (enumByCode == null) {
                    return ret;
                }
                switch (enumByCode) {
                    case PENDING:
                        ret = PROCESSING.getCode();
                        break;
                    case DELETED:
                        ret = FAILED.getCode();
                        break;
                    case COMPLETED:
                        ret = COMPLETED.getCode();
                        break;
                    default:
                        return ret;
                }
            }

            return ret;

        }

        @Override
        public String getCode() {
            return code;
        }
        @Override
        public String getDesc() {
            return desc;
        }
    }

}
