package com.liquidnet.service.adam.constant;

public class AdamPayerConstants {

    /**
     * 状态类型
     */
    public enum StatusEnum implements AdamBaseEnum {
        NORMAL("normal", "normal"),
        DELETE("delete", "delete"),
        ;

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

    /**
     * 实体类型
     */
    public enum LegalEntityTypeEnum implements AdamBaseEnum {
        INDIVIDUAL("individual", "Individual"),
        COMPANY("company", "Company"),
        ;

        public static LegalEntityTypeEnum getEnumByCode(String code) {
            LegalEntityTypeEnum[] array = values();
            for (LegalEntityTypeEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        LegalEntityTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

    /**
     * 个人id类型
     */
    public enum IndividualIdTypeEnum implements AdamBaseEnum {
        none("none", "none"),
        drivers_license("drivers_license", "drivers license"),
        social_security_number("social_security_number", "social security number"),
        green_card("green_card", "green card"),
        passport("passport", "passport"),
        visa("visa", "visa"),
        matricula_consular("matricula_consular", "matricula consular"),
        registro_federal_de_contribuyentes("registro_federal_de_contribuyentes", "registro federal de contribuyentes"),
        credential_de_elector("credential_de_elector", "credential de elector"),
        social_insurance_number("social_insurance_number", "social insurance number"),
        citizenship_papers("citizenship_papers", "citizenship papers"),
        drivers_license_canadian("drivers_license_canadian", "drivers license canadian"),
        existing_credit_card_details("existing_credit_card_details", "existing credit card details"),
        employer_identification_number("employer_identification_number", "employer identification number"),
        national_id("national_id", "national id"),
        others("others", "others"),
        incorporation_number("incorporation_number", "incorporation number");

        public static IndividualIdTypeEnum getEnumByCode(String code) {
            IndividualIdTypeEnum[] array = values();
            for (IndividualIdTypeEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        IndividualIdTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

}
