package com.liquidnet.service.adam.constant;

public class AdamPayoutBeneficiaryConstants {

    public enum ExistingEnum implements AdamBaseEnum {
        Existing("existing", "Existing"),
        New("new", "New"),
        ;

        public static ExistingEnum getEnumByCode(String code) {
            ExistingEnum[] array = values();
            for (ExistingEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        ExistingEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
