package com.liquidnet.service.adam.constant;

import com.liquidnet.service.bank.currencycloud.constant.BankCcPaymentConstants;
import org.springframework.util.StringUtils;

public class AdamPayoutConstants {
    public enum StatusEnum implements AdamBaseEnum {
        READY_TO_PROCESS("ready_to_process", "Ready to Process"),
        AWAITING_FUNDS("awaiting_funds", "Awaiting Funds"),
        PROCESSING("processing", "Processing"),
        CANCELLED("cancelled", "Cancelled"),
        FAILED("failed", "Failed"),
        COMPLETED("completed", "Completed"),
        ;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        public static String getByBankStatus(String bankChannel, String bankConversionStatus) {
            String ret = null;
            if (StringUtils.isEmpty(bankChannel)) {
                bankChannel = AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode();
            }
            if (AdamBankConstants.BankChannelEnum.CURRENCY_CLOUD.getCode().equals(bankChannel)) {
                BankCcPaymentConstants.StatusEnum enumByCode = BankCcPaymentConstants.StatusEnum.getEnumByCode(bankConversionStatus);
                if (enumByCode == null) {
                    return ret;
                }

                switch (enumByCode) {
                    case NEW:
                        ret = READY_TO_PROCESS.getCode();
                        break;
                    case READY_TO_SEND:
                        ret = PROCESSING.getCode();
                        break;
                    case COMPLETED:
                        ret = COMPLETED.getCode();
                        break;
                    case FAILED:
                        ret = FAILED.getCode();
                        break;
                    case RELEASED:
                        ret = PROCESSING.getCode();
                        break;
                    case SUSPENDED:
                        ret = PROCESSING.getCode();
                        break;
                    case AWAITING_AUTHORISATION:
                        ret = PROCESSING.getCode();
                        break;
                    case SUBMITTED:
                        ret = PROCESSING.getCode();
                        break;
                    case AUTHORISED:
                        ret = PROCESSING.getCode();
                        break;
                    case DELETED:
                        ret = FAILED.getCode();
                        break;
                    default:
                        return ret;
                }
            }

            return ret;

        }

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum SpotForwardEnum implements AdamBaseEnum {
        SPOT("spot", "即期"),
        FORWARD("forward", "远期"),
        ;

        public static SpotForwardEnum getEnumByCode(String code) {
            SpotForwardEnum[] array = values();
            for (SpotForwardEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        SpotForwardEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
