package com.liquidnet.service.adam.constant;

public class AdamPayoutPayerConstants {

    public enum SenderDefaultEnum implements AdamBaseEnum {
        YES("1", "Yes"),
        NO("0", "No"),
        ;

        public static SenderDefaultEnum getEnumByCode(String code) {
            SenderDefaultEnum[] array = values();
            for (SenderDefaultEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        SenderDefaultEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }


    public enum SenderExistingEnum implements AdamBaseEnum {
        Existing("existing", "Existing"),
        New("new", "New"),
        ;

        public static SenderExistingEnum getEnumByCode(String code) {
            SenderExistingEnum[] array = values();
            for (SenderExistingEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        SenderExistingEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
