package com.liquidnet.service.adam.constant;

public class AdamTransactionConstants {

    public enum TypeEnum implements AdamBaseEnum {
        FX_CONVERSION("FX", "FX Conversion"),
        FUNDING("FI", "Funding"),
        PAYOUT("PO", "Payout");

        private String code;

        private String desc;

        TypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static TypeEnum getEnumByCode(String code) {
            TypeEnum[] array = values();
            for (TypeEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum StatusEnum implements AdamBaseEnum {
        READY_TO_PROCESS("ready_to_process", "Ready to Process"),
        READY_TO_SETTLE("ready_to_settle", "Ready to Settle"),
        AWAITING_FUNDS("awaiting_funds", "Awaiting Funds"),
        PROCESSING("processing", "Processing"),
        CANCELLED("cancelled", "Cancelled"),
        FAILED("failed", "Failed"),
        COMPLETED("completed", "Completed"),

        ;

        public static StatusEnum getEnumByCode(String code) {
            StatusEnum[] array = values();
            for (StatusEnum codeEnum : array) {
                if (codeEnum.code.equals(code)) {
                    return codeEnum;
                }
            }
            return null;
        }

        private String code;

        private String desc;

        StatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum FundsDirectionEnum implements AdamBaseEnum {
        DEBIT("D", "Out(-)"),
        CREDIT("C", "In(+)");

        private String code;

        private String desc;

        FundsDirectionEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

    public enum FinNotifyStatusEnum implements AdamBaseEnum {
        PUSHED("0", "未推送"),
        NOT_PUSHED("1", "已推送");

        private String code;

        private String desc;

        FinNotifyStatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }
    }

}
