package com.liquidnet.service.adam.constant;

/**
 * 公司常量
 *
 * @author LiChen
 * @date 2020-09-16 16:16
 */
public class AdamUserFeedbackConstants {

    public enum CategoryEnum implements AdamBaseEnum {
        ACCOUNT("account", "Account"),
        USER("user", "Users"),
        PROFILE("profile", "Profile"),
        WALLET("wallet", "Wallets"),
        BALANCE("balance", "Balances"),
        TRANSACTION("transaction", "Transactions"),
        OTHER("other", "Others"),
        ;

        private String code;

        private String desc;

        CategoryEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        @Override
        public String getCode() {
            return code;
        }

        @Override
        public String getDesc() {
            return desc;
        }

    }

}
