package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * create account
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "创建账户参数")
public class AdamAccountCreateParam {

    @ApiModelProperty(value = "comid", hidden = true)
    private String comId;

    @ApiModelProperty(value = "币种", required = true)
    private String currency;

    @ApiModelProperty(value = "账户名称,选填")
    private String name;

    @ApiModelProperty(value = "渠道标识", hidden = true)
    private String bankChannel;

    @ApiModelProperty(value = "来源标识", hidden = true)
    private String source;

    @ApiModelProperty(value = "userId", hidden = true)
    private String userId;

}
