package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "AdamAdminisWalletParam", description = "Parameters of wallet access permission update")
public class AdamAdminisWalletParam implements java.io.Serializable {
    private static final long serialVersionUID = 9041688259763382776L;
    @ApiModelProperty(position = 11, required = true, value = "Details of wallet access [Map<String, List<String>>]", example = "{\"walletNo1\":[\"userIdA\",\"userIdB\",\"userIdC\"],\"walletNo2\":[\"userIdA\"]}")
    private Map<String, List<String>> walletAccessListMap;
    @ApiModelProperty(position = 12, required = true, value = "New wallet assign to all user [Yes,No]")
    private String newWalletAssignToAllUser;
}
