package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * ConInfo Dto
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "公司信息")
public class AdamComInfoDto {

    @ApiModelProperty(value = "主键id", position = 1)
    private String id;

    @ApiModelProperty(value = "公司名称", position = 2)
    private String name;

    @ApiModelProperty(value = "状态", position = 2)
    private String state;

    @ApiModelProperty(value = "公司类型", position = 3)
    private String type;

    @ApiModelProperty(value = "公司类型-其他", position = 4)
    private String typeOther;

    @ApiModelProperty(value = "持股25%以上的数量", position = 4)
    private String stakeNumber;

    @ApiModelProperty(value = "国家/地区代码", position = 5)
    private String registrationCountryCode;

    @ApiModelProperty(value = "注册号", position = 6)
    private String registrationNumber;

    @ApiModelProperty(value = "网址", position = 7)
    private String websiteUrl;

    @ApiModelProperty(value = "实体结构", position = 8)
    private String entityStructure;

    @ApiModelProperty(value = "营业年限", position = 9)
    private String businessYears;

    @ApiModelProperty(value = "行业类别", position = 10)
    private String industryCategory;

    @ApiModelProperty(value = "行业类别-其他", position = 11)
    private String industryCategoryOther;

    @ApiModelProperty(value = "电话代码", position = 12)
    private String phoneCode;

    @ApiModelProperty(value = "电话号码", position = 13)
    private String phoneNumber;

    @ApiModelProperty(value = "地址-国家", position = 14)
    private String addressCountry;

    @ApiModelProperty(value = "地址-州/省", position = 15)
    private String addressProvince;

    @ApiModelProperty(value = "地址-城市", position = 16)
    private String addressCity;

    @ApiModelProperty(value = "地址-街道", position = 17)
    private String addressStreet;

    @ApiModelProperty(value = "地址-邮编", position = 18)
    private String addressPostCode;

}
