package com.liquidnet.service.adam.dto;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 公司法人
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-25
 */
@ApiModel(description = "公司法人")
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamComLegalPersonDto implements Serializable {

    @ApiModelProperty(value = "公司id", required = true, position = 1)
    private String comId;

    @ApiModelProperty(value = "全名", required = true, position = 1)
    private String fullName;

    @ApiModelProperty(value = "出生日期", required = true, position = 2)
    private String dateBirth;

    @ApiModelProperty(value = "电话号-国家/地区代码", required = true, position = 3)
    private String phoneCode;

    @ApiModelProperty(value = "电话号-号码", required = true, position = 4)
    private String phoneNumber;

    @ApiModelProperty(value = "邮件地址", required = true)
    private String email;

    @ApiModelProperty(value = "id签发国家/地区代码", required = true, position = 5)
    private String idCountryCode;

    @ApiModelProperty(value = "id类型", required = true, position = 6)
    private String idType;

    @ApiModelProperty(value = "id号", required = true, position = 7)
    private String idNumber;

    @ApiModelProperty(value = "id文件证明", required = true,example = "[{\"localName\":\"\",\"serverName\":\"\"}]",position = 7)
    private String idProof;

    @ApiModelProperty(value = "国家", required = true, position = 8)
    private String addressCountry;

    @ApiModelProperty(value = "州/省", required = true, position = 9)
    private String addressProvince;

    @ApiModelProperty(value = "城市", required = true, position = 10)
    private String addressCity;

    @ApiModelProperty(value = "街道", required = true, position = 11)
    private String addressStreet;

    @ApiModelProperty(value = "邮编", required = true, position = 12)
    private String addressPostCode;

    @ApiModelProperty(value = "住宅文件证明", required = true,example = "[{\"localName\":\"\",\"serverName\":\"\"}]", position = 7)
    private String addressProof;

}
