package com.liquidnet.service.adam.dto;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 公司问卷json entity
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "公司问卷")
public class AdamComQuestionDto {

    @ApiModelProperty(value = "编号", required = true)
    private String number;

    @ApiModelProperty(value = "问题", required = true)
    private String question;

    @ApiModelProperty(value = "答案", required = true)
    private String answer;

    @ApiModelProperty(value = "问题类型,file类型,答案格式是 服务器文件名:本地文件名", required = true, allowableValues = "file,radio,text")
    private String answerType;

    @ApiModelProperty(value = "子问题List")
    private List<AdamComQuestionDto> subQuestion;

    public static void main(String[] args) {
        AdamComQuestionDto adamComQuestionDto = new AdamComQuestionDto();
        System.out.println(JSON.toJSONString(adamComQuestionDto));

    }

}
