package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 公司股东信息参数
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Data
@ApiModel(description = "公司股东信息")
public class AdamComShareholderDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id", position = 1)
    private String id;

    @ApiModelProperty(value = "公司id", position = 15)
    private String comId;

    @ApiModelProperty(value = "职位", position = 20)
    private String position;

    @ApiModelProperty(value = "全名", position = 30)
    private String fullName;

    @ApiModelProperty(value = "出生日期", position = 40)
    private String dateBirth;

    @ApiModelProperty(value = "id颁发国家代码", position = 50)
    private String idCountryCode;

    @ApiModelProperty(value = "住宅地址", position = 60)
    private String residentialAddress;

    @ApiModelProperty(value = "id证明", position = 70)
    private String idProof;

    @ApiModelProperty(value = "住宅证明", position = 80)
    private String addressProof;

}
