package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * <p>
 * 公司股东信息参数
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Data
public class AdamComShareholderParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "公司id", hidden = true)
    private String comId;

    @ApiModelProperty(value = "The number of individuals or companies with at least a 25% stake in the company", required = true, position = 10)
    private String stakeNumber;

    @ApiModelProperty(value = "职位", required = true, position = 20)
    private String position;

    @ApiModelProperty(value = "全名", required = true, position = 30)
    private String fullName;

    @ApiModelProperty(value = "出生日期", required = true, example = "yyyy-MM-dd", position = 40)
    private String dateBirth;

    @ApiModelProperty(value = "id颁发国家代码", required = true, position = 50)
    private String idCountryCode;

    @ApiModelProperty(value = "住宅地址", required = true, position = 60)
    private String residentialAddress;

    @ApiModelProperty(value = "id证明", required = true, position = 70)
    private String idProof;

    @ApiModelProperty(value = "住宅证明", required = true, position = 80)
    private String addressProof;

}
