package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * conversion param
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "conversion param")
public class AdamConversionParam {

    @ApiModelProperty(hidden = true)
    private String id;

    @ApiModelProperty(hidden = true)
    private String comId;

    @ApiModelProperty(hidden = true)
    private String userId;

    @ApiModelProperty(hidden = true)
    private String status;

    @ApiModelProperty(required = true)
    private String fromWalletNo;

    private String fromWalletName;

    @ApiModelProperty(required = true)
    private String toWalletNo;

    private String toWalletName;

    @ApiModelProperty(required = true)
    private BigDecimal sellAmount;

    @ApiModelProperty(required = true)
    private String sellCurrency;

    @ApiModelProperty(required = true)
    private String buyCurrency;

    @ApiModelProperty(required = true)
    private BigDecimal buyAmount;

    @ApiModelProperty(required = true)
    private String fixedSide;

    @ApiModelProperty(required = true)
    private BigDecimal quoteRate;

    @ApiModelProperty(required = true)
    private BigDecimal executionRate;

    @ApiModelProperty(required = true,value = "yyyy-MM-dd HH:mm:ss")
    private String conversionDateAt;

    @ApiModelProperty(required = true,value = "yyyy-MM-dd HH:mm:ss")
    private String settlementDateAt;

}
