package com.liquidnet.service.adam.dto;

import lombok.Data;

import java.util.List;

/**
 * 下发收款人 接收付款方式Dto
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
public class AdamPayoutMethodDto {

    /**
     * 付款方式,regular,priority
     */
    private String paymentType;

    private List<Content> content;

    /**
     * 付款方式具体参数和值
     * code是参数,例: bank_code
     * val 是参数值,例: PCBCCNBJXXX
     */
    @Data
    public static class Content {

        private String code;

        private String val;

    }

}
