package com.liquidnet.service.adam.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel
@Data
public class AdamUserSignInCheckRespDto {

    @ApiModelProperty(value = "邮箱", position = 0)
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String email;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty(value = "电话号", position = 1)
    private String phone;

    @ApiModelProperty(value = "是否需要绑定手机号进行二次验证", position = 2)
    private boolean needBindPhoneNumber = true;

    @ApiModelProperty(value = "是否需要进行邮箱确认", position = 3)
    private boolean needConfirmEmail = true;

}
