package com.liquidnet.service.adam.dto.admin.transaction;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class AdamConversionRecordReq implements Serializable {
    @ApiModelProperty("transactionId")
    private String transactionId;

    @ApiModelProperty("fromWallet")
    private String fromWallet;

    @ApiModelProperty("toWallet")
    private String toWallet;

    @ApiModelProperty("fromCurrency")
    private String fromCurrency;

    @ApiModelProperty("toCurrency")
    private String toCurrency;

    @ApiModelProperty(value = "amountType", example = "buy,sell")
    private String amountType;

    @ApiModelProperty(value = "transactionAmountBegin")
    private String transactionAmountBegin;
    @ApiModelProperty(value = "transactionAmountEnd")
    private String transactionAmountEnd;

    @ApiModelProperty("transactionStatus")
    private String transactionStatus;

    @ApiModelProperty(value = "createDateBegin", example = "yyyy-MM_dd")
    private String createDateBegin;
    @ApiModelProperty(value = "createDateEnd", example = "yyyy-MM_dd")
    private String createDateEnd;

    @ApiModelProperty(value = "conversionDateBegin", example = "yyyy-MM_dd")
    private String conversionDateBegin;
    @ApiModelProperty(value = "conversionDateEnd", example = "yyyy-MM_dd")
    private String conversionDateEnd;

    @ApiModelProperty(value = "settlementDateBegin", example = "yyyy-MM_dd")
    private String settlementDateBegin;
    @ApiModelProperty(value = "settlementDateEnd", example = "yyyy-MM_dd")
    private String settlementDateEnd;
}
