package com.liquidnet.service.adam.dto.base;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel()
@Data
public class AdamResultDto<T> implements Serializable {

    @ApiModelProperty(value = "错误码,0代表成功", position = -9998)
    private String code = ErrorCode.SUCCESS.getCode();

    @ApiModelProperty(value = "错误描述", position = -9997)
    private String message;

    @ApiModelProperty
    private T data;

    public boolean isSuccess() {
        return this.code.equals(AdamErrorCode.SUCCESS.getCode());
    }

    public AdamResultDto() {
    }

    public AdamResultDto(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public AdamResultDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public AdamResultDto(AdamErrorCode error) {
        if (error != null) {
            this.code = error.getCode();
            this.message = error.getVal();
        }

    }

    public AdamResultDto(AdamErrorCode error, T data) {
        this.code = error.getCode();
        this.message = error.getVal();
        this.data = data;
    }

    public static <Object> AdamResultDto<Object> result(String code, String message, Object data) {
        return new AdamResultDto<>(code, message, data);
    }

    public static <Object> AdamResultDto<Object> success(Object data) {
        return new AdamResultDto<>(AdamErrorCode.SUCCESS, data);
    }

    public static <Object> AdamResultDto<Object> success() {
        return new AdamResultDto<>(AdamErrorCode.SUCCESS);
    }

    public static <Object> AdamResultDto<Object> failure(AdamErrorCode error) {
        return new AdamResultDto<>(error);
    }

    public static <Object> AdamResultDto<Object> failure(AdamErrorCode error, Object data) {
        return new AdamResultDto<>(error, data);
    }

    public static <Object> AdamResultDto<Object> failure(String code, String message) {
        return new AdamResultDto<>(code, message);
    }

    public static ResponseDto getResponseDto(AdamResultDto dto) {
        return new ResponseDto<>(dto.getCode(), dto.getMessage(), dto.getData());
    }

    public static AdamResultDto getAdamResultDto(ResponseDto dto) {
        return new AdamResultDto(dto.getCode(), dto.getMessage(), dto.getData());
    }

}
