package com.liquidnet.service.adam.dto.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
@ApiModel("公司信息查询条件")
public class AdamComInfoQuery {

    @ApiModelProperty(value = "公司id")
    private String comId;

    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    @ApiModelProperty(value = "创建时间范围始")
    private LocalDateTime createdTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    @ApiModelProperty(value = "创建时间范围止")
    private LocalDateTime createdTimeEnd;

}
