package com.liquidnet.service.adam.dto.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamCommonQuery", description = "Parameters of common query")
public class AdamCommonQuery implements java.io.Serializable {
    private static final long serialVersionUID = 4324147013916795509L;
    @ApiModelProperty(position = 1, value = "Page number [1,2,3...]", example = "1")
    private Integer pageNo;
    @ApiModelProperty(position = 2, value = "Page size [10,20]", example = "20")
    private Integer pageSize;
    @ApiModelProperty(position = 3, value = "Search parameters")
    private String search;
    @ApiModelProperty(position = 4, value = "Periods type", example = "1")
    private String periodsType;
    @ApiModelProperty(position = 5, value = "Start time")
    private String startTime;
    @ApiModelProperty(position = 6, value = "End time")
    private String endTime;
    @ApiModelProperty(position = 7, value = "Company ID")
    private String comId;
    @ApiModelProperty(position = 8, value = "Adam user ID")
    private String userId;
}
