package com.liquidnet.service.adam.dto.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("交易信息查询条件")
public class AdamTransactionQuery {
    @ApiModelProperty(hidden = true)
    private String comId;

    @ApiModelProperty("wallet no")
    private String finWalletNo;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "创建时间起,yyyy-MM-dd")
    private String createDateFrom;

    @ApiModelProperty(value = "创建时间止,yyyy-MM-dd")
    private String createDateTo;

    @ApiModelProperty(value = "完成时间起,yyyy-MM-dd")
    private String completeDateFrom;

    @ApiModelProperty(value = "完成时间止,yyyy-MM-dd")
    private String completeDateTo;

    @ApiModelProperty("交易number")
    private String number;

    @ApiModelProperty("交易类型")
    private String type;

    @ApiModelProperty("备注")
    private String reference;

    @ApiModelProperty("出入账")
    private String fundDirection;

}
