package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamAccountCreateParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamAccountWallet;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;

/**
 * <p>
 * 公司账户 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
public interface IAdamAccountApiService {

    /**
     * create account wallet
     */
    AdamResultDto<AdamAccountWallet> createAccountWallet(AdamAccountCreateParam param);


    /**
     * bank cc 回调通知创建wallet
     */
    AdamResultDto pushNotifyBankCcBalance(BankCcBalance balance);

    /**
     * delete wallet
     */
    AdamResultDto deleteWallet(String comId, String finWalletNo);

    /**
     * update wallet name
     */
    AdamResultDto updateWalletName(String comId, String finWalletNo, String name);

}
