package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.AdamBeneficiaryParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.dto.query.AdamBeneficiaryQuery;
import com.liquidnet.service.adam.entity.AdamBeneficiary;
import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.adam.entity.AdamPayer;

import java.util.List;

/**
 * <p>
 * 收款人信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-02
 */
public interface IAdamBeneficiaryService {

    AdamBeneficiary selectById(String id);

    AdamResultDto<AdamBeneficiary> select(String id, String comId);

    AdamResultDto<AdamBeneficiary> create(AdamBeneficiary beneficiary);

    AdamResultDto<AdamBeneficiary> update(AdamBeneficiary beneficiary);

    AdamResultDto delete(String id, String comId);

    List<AdamBeneficiary> selectList(AdamBeneficiaryParam param);

    Page<AdamBeneficiary> selectPage(Integer pageNum, Integer pageSize, AdamBeneficiaryQuery selectParam);

}
