package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.AdamComInfoDto;
import com.liquidnet.service.adam.dto.AdamComInfoParam;
import com.liquidnet.service.adam.dto.query.AdamComInfoQuery;
import com.liquidnet.service.adam.entity.AdamComInfo;

/**
 * <p>
 * 公司信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
public interface IAdamComInfoService {

    /**
     * 主键查询
     */
    AdamComInfo selectById(String id);

    /**
     * 新增
     */
    int insert(AdamComInfoParam param);

    /**
     * 更新-主键id更新
     */
    int updateById(AdamComInfoParam param);

    /**
     * 条件更新
     *
     * @param updateDto   更新参数
     * @param updateParam 更新条件
     */
    int update(AdamComInfoDto updateDto, AdamComInfoParam updateParam);

    /**
     * 分页查询
     *
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @param query    查询条件
     */
    Page<AdamComInfo> queryPageList(int pageNum, int pageSize, AdamComInfoQuery query);

}
