package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamConversionDateDto;
import com.liquidnet.service.adam.dto.AdamConversionParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamConversion;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;

/**
 * <p>
 * 换汇 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-10
 */
public interface IAdamConversionApiService {

    /**
     * 创建换汇
     */
    AdamResultDto<AdamConversion> createConversion(AdamConversionParam param);

    /**
     * 初始化换汇
     */
    AdamResultDto<AdamConversion> initConversion(AdamConversionParam param);


    /**
     * 创建渠道换汇
     */
    AdamResultDto<BankCcConversionDto> createCcConversion(AdamConversionParam param);

    /**
     * cc 渠道换汇
     */
    AdamResultDto bankCcConversion(BankCcConversionDto param);

    /**
     * to fin push conversion
     */
    AdamResultDto pushFinConversion(String conversionId);

    AdamResultDto<AdamConversionDateDto> getConversionDates(String bankChannel, String conversionPair, String startDate);

    /**
     * 发送确认1,set redis
     *
     * @param conversionId 换汇id
     * @param comId        公司id
     */
    AdamResultDto sendConfirm1(String conversionId, String comId);
    
    /**
     * 发送确认2,发送邮件,附件内容:换汇详情pdf
     */
    AdamResultDto sendConfirm2();

}
