package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.adam.entity.AdamLoginOnline;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 在线用户记录 服务类
 * </p>
 *
 * @author jiabin.an
 * @since 2020-11-23
 */
public interface IAdamLoginOnlineService extends IService<AdamLoginOnline> {
    /**
     * 通过会话序号查询信息
     *
     * @param userId 会话ID
     * @return 在线用户信息
     */
    public AdamLoginOnline selectOnlineByUserId(String userId);

    public AdamLoginOnline selectOnlineBySessionId(String sessionId);

    /**
     * 通过会话序号删除信息
     *
     * @param userId 用户id
     * @return 在线用户信息
     */
    public void deleteOnlineByUserId(String userId);

    public void deleteOnlineBySessionId(String sessionId);

    /**
     * 通过会话序号删除信息
     *
     * @param sessions 会话ID集合
     * @return 在线用户信息
     */
    public void batchDeleteOnline(List<String> sessions);

    /**
     * 保存会话信息
     *
     * @param online 会话信息
     */
    public void saveOnline(AdamLoginOnline online);

    /**
     * 查询会话集合
     *
     * @param userOnline 分页参数
     * @return 会话集合
     */
    public List<AdamLoginOnline> selectUserOnlineList(AdamLoginOnline userOnline);

    /**
     * 查询会话集合
     *
     * @param expiredDate 有效期
     * @return 会话集合
     */
    public List<AdamLoginOnline> selectOnlineByExpired(Date expiredDate);
}
