package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.query.AdamPayerQuery;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamPayer;

import java.util.List;

/**
 * <p>
 * 付款人信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-02
 */
public interface IAdamPayerService {

    /**
     * 主键查询
     */
    AdamPayer selectById(String id);

    /**
     * 主键查询
     *
     * @param comId 公司id
     */
    AdamResultDto<AdamPayer> select(String id, String comId);

    /**
     * 条件查询
     */
    List<AdamPayer> selectList(AdamPayerQuery param);

    /**
     * 分页查询
     */
    Page<AdamPayer> selectPage(Integer pageNum, Integer pageSize, AdamPayerQuery param);

    /**
     * 创建付款人信息
     */
    AdamResultDto<AdamPayer> create(AdamPayer payer);

    /**
     * 更新收款人信息
     */
    AdamResultDto<AdamPayer> update(AdamPayer payer);

    /**
     * 删除收款人信息
     */
    AdamResultDto delete(String id, String comId);

}
