package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.AdamPayoutDetailParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;

public interface IAdamPayoutApiService {
    /**
     * 创建下发
     * @return
     */
    AdamResultDto<AdamPayoutDetailDto> createPayout(AdamPayoutDetailParam param);

    /**
     * 编辑下发
     */
    AdamResultDto<AdamPayoutDetailDto> editPayout(AdamPayoutDetailParam param);

    /**
     * 取消下发
     */
    AdamResultDto cancelledPayout(String comId, String payoutId);

    /**
     * 真正执行下发
     */
    AdamResultDto doPayout(String payoutId);

    /**
     * 异步执行下发
     */
    void asyncDoPayout(String payoutId);

    /**
     * 异步等待充值下发
     * <br/>充值到账
     * <br/>换汇入金
     * <br/>每天定时任务检查等待充值
     */
    void asyncAwaitingFundsDoPayout(String finWalletNo);

    /**
     * 创建cc渠道下发
     */
    AdamResultDto<BankCcConversionDto> createCcPayout(String payoutId, String transactionId);

    /**
     * 根据cc渠道下发数据处理状态
     */
    AdamResultDto bankCcPayout(BankCcPayment param);

}
