package com.liquidnet.service.adam.service;

import com.liquidnet.service.account.wallet.vo.WalletTransactionInfoVo;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamConversion;
import com.liquidnet.service.adam.entity.AdamFunding;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.entity.AdamTransaction;

import java.util.List;

/**
 * <p>
 * 交易记录表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
public interface IAdamTransactionApiService {

    /**
     * 生成编号
     */
    String generateNumber(String type);

    /**
     * 向account推送交易信息
     * param 要求必须是唯一的交易信息
     */
    AdamResultDto<String> pushFinTransaction(AdamTransaction param);

    int updateFunding(AdamTransaction transaction, AdamFunding funding);

    int updatePayout(AdamTransaction transaction, AdamPayout payout);

    int updateConversion(AdamTransaction transaction, AdamConversion conversion);

    void asyncUpdateBalance(List<WalletTransactionInfoVo> list);

}
