package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.AdamTransactionParam;
import com.liquidnet.service.adam.dto.query.AdamTransactionQuery;
import com.liquidnet.service.adam.entity.AdamTransaction;
import com.liquidnet.service.adam.vo.AdamConversionDetailVo;
import com.liquidnet.service.adam.vo.AdamFundingDetailVo;
import com.liquidnet.service.adam.vo.AdamPayoutDetailVo;

import java.util.List;

/**
 * <p>
 * 交易记录表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
public interface IAdamTransactionService {

    int updateById(AdamTransaction adamTransaction);

    int insert(AdamTransaction adamTransaction);

    AdamTransaction selectById(String id);

    AdamTransaction selectOne(AdamTransactionParam param);

    List<AdamTransaction> selectList(AdamTransactionParam param);

    Page<AdamTransaction> queryPageList(int pageNum, int pageSize,
                                        AdamTransactionQuery queryParam);

    /**
     * 查询充值交易详情
     */
    AdamFundingDetailVo getFundingDetail(String comId, String transactionId);

    /**
     * 查询下发交易详情
     */
    AdamPayoutDetailVo getPayoutDetail(String comId, String transactionId);

    /**
     * 查询换汇交易详情
     */
    AdamConversionDetailVo getConversionDetail(String comId, String transactionId);

}
