package com.liquidnet.service.adam.service;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamUser;

/**
 * <p>
 * 用户信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
public interface IAdamUserEmailService {

    /**
     * 用户注册,邮箱认证
     * @return url认证链接
     */
    String userEmailAuth(AdamUser adamUser) throws Exception;

    /**
     * 用户点击邮箱链接,确认邮箱
     */
    AdamResultDto<Object> confirmEmail(String confirmKey) throws Exception;

    /**
     * 重新发送邮箱的确认邮件
     */
    AdamResultDto resendEmail(String email) throws Exception;

    /**
     * 更新邮箱,发送验证码
     *
     * @param userId   用户id
     * @param newEmail 新邮箱地址
     * @param password 用户密码
     */
    AdamResultDto updateVerifyCodeSend(String userId, String newEmail, String password);

    /**
     * 更新邮箱,确认验证码
     *
     * @param verifyCode 验证码
     */
    AdamResultDto updateVerifyCodeConfirm(AdamCurrentUser currentUser, String verifyCode);

    String userEmailAuthForInvite(AdamUser adamUser, boolean isFirst) throws Exception;

    ResponseDto<?> confirmEmailByInvite(String key, String pw);
}



