package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamUser;

/**
 * <p>
 * 用户信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
public interface IAdamUserPasswordService {


    /**
     * 用户密码加密
     *
     * @param password 明文密码
     *
     * @return 加密后密码
     */
    String getPasswordMD5(String password);

    /**
     * 校验密码格式
     *
     * @param password 明文密码
     */
    AdamResultDto checkPasswordFormat(String password);


    AdamResultDto checkLoginPassword(AdamUser adamUser, String password);

    /**
     * 用户更新密码
     *
     * @param userId 用户id
     * @param oldPw  旧密码
     * @param newPw  新密码
     */
    AdamResultDto update(String userId, String oldPw, String newPw);

    /**
     * 忘记密码,发送验证码
     *
     * @param email        账号
     * @param verifyMethod 验证码发送方式,email,phone
     */
    AdamResultDto forgetVerifyCodeSend(String email, String verifyMethod);

    /**
     * 忘记密码,确认验证码
     *
     * @param email      账号邮箱
     * @param verifyCode 验证码
     * @param newPw      新密码,为空只校验验证码
     */
    AdamResultDto forgetVerifyCodeConfirm(String email, String verifyCode, String newPw);

}



