package com.liquidnet.service.adam.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.constant.AdamUserConstants;
import com.liquidnet.service.adam.dto.AdamAdminisUserParam;
import com.liquidnet.service.adam.dto.AdamUserSignInCheckRespDto;
import com.liquidnet.service.adam.dto.AdamUserSignInRespDto;
import com.liquidnet.service.adam.dto.AdamUserSignUpParam;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.dto.query.AdamCommonQuery;
import com.liquidnet.service.adam.dto.query.AdamUserQuery;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.vo.AdamUserProfileVo;

import java.util.List;

/**
 * <p>
 * 用户信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
public interface IAdamUserService {

    AdamResultDto<Object> userSignUp(AdamUserSignUpParam userSignUpParams) throws Exception;

    AdamResultDto<AdamUserSignInCheckRespDto> signInCheck(String email, String password);

    /**
     * 绑定手机号,并发送验证码
     * @param email 邮箱账号
     * @param phoneCode 电话代码
     * @param phoneNumber 电话号码
     */
    AdamResultDto<Object> bindUserPhoneAndSendSMSCode(String email, String phoneCode,String phoneNumber);

    AdamResultDto<AdamUserSignInRespDto> confirmSMSCode(String email, String smsCode, String ip);

    AdamUser selectById(String userId);

    AdamUser selectOne(AdamUser adamUser);

    Page<AdamUser> queryPageList(int pageIndex, int pageSize, AdamUserQuery queryParam);

    AdamUser getUserByEmail(String email);

    int updateById(AdamUser adamUser);

    List<AdamUser> queryListForAdminis(String comId);

    Page<AdamUser> queryPageListForAdminis(AdamCommonQuery query);

    AdamUserProfileVo queryByUserId(String uid, String hisTag, int pageNo, int pageSize);

    ResponseDto<?> inviteUserDo(AdamCurrentUser currentUser, String roleName, AdamAdminisUserParam parameter) throws Exception;

    ResponseDto<?> updateInviteDo(AdamCurrentUser currentUser, String roleName, AdamAdminisUserParam parameter) throws Exception;

    int updateStatus(String userId, AdamUserConstants.UserStatusEnum statusEnum);
}
