package com.liquidnet.service.adam.service.admin.transaction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.AdamTransactionDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamConversionRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamRechargeRecordReq;

/**
 * <p>
 * 交易信息记录表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-20
 */
public interface IAdminTransactionRecordService {
    Page<AdamTransactionDto> queryRechargePageList(int pageNum, int pageSize,
                                                   AdamRechargeRecordReq queryParam,
                                                   String comId);

    Page<AdamTransactionDto> queryPayoutPageList(int pageNum, int pageSize,
                                                   AdamPayoutRecordReq queryParam,
                                                   String comId);

    Page<AdamTransactionDto> queryConversionPageList(int pageNum, int pageSize,
                                                           AdamConversionRecordReq queryParam,
                                                           String comId);

    AdamPayoutDetailDto getPayoutDetailByOrderId(String orderId);

}
