package com.liquidnet.service.adam.service.sys;

/**
 * MongoDB服务
 *
 * @author lichen
 */
public interface IAdamSysMongoService {

    /**
     * 存入文件
     *
     * @param bytes 文件字节数组
     * @return filename 文件名称,示例:d6af9b2647ca413fa92415bd6756fde0.mp4
     */
    String uploadFile(byte[] bytes, String fileName);

    /**
     * 删除文件
     *
     * @param filename 文件名,示例:d6af9b2647ca413fa92415bd6756fde0.mp4
     * @return true/false
     */
    boolean deleteFile(String filename);

    /**
     * 获取文件
     *
     * @param filename 文件名,示例:d6af9b2647ca413fa92415bd6756fde0.mp4
     * @return GridFsResource
     */
    byte[] downFile(String filename);

}
